// PageDeviceInfo.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageDeviceInfo.h"
#include "Include\CLS_NVDSDK_Interface.h"

// CPageDeviceInfo Ի

IMPLEMENT_DYNAMIC(CPageDeviceInfo, CDialog)

CPageDeviceInfo::CPageDeviceInfo(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageDeviceInfo::IDD, pParent)
{
	m_lLogonID = -1;
}

CPageDeviceInfo::~CPageDeviceInfo()
{
}

void CPageDeviceInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_DEV_ID, m_cboDevID);
	DDX_Control(pDX, IDC_EDT_CTRLCARD, m_edtCtrlNum);
	DDX_Control(pDX, IDC_EDT_ALARMIN, m_edtAlarmIn);
	DDX_Control(pDX, IDC_EDT_ALARMOUT, m_edtAlarmOut);
	DDX_Control(pDX, IDC_EDT_SLOTDNUM, m_edtSlotdNum);
}


BEGIN_MESSAGE_MAP(CPageDeviceInfo, CDialog)
	ON_CBN_SELCHANGE(IDC_CBO_DEV_ID, &CPageDeviceInfo::OnCbnSelchangeCboDevId)
END_MESSAGE_MAP()

int CPageDeviceInfo::Initialize(TDECPARAM* _pdecParam)
{
	return TRUE;
}
// CPageDeviceInfo Ϣ

void CPageDeviceInfo::OnCbnSelchangeCboDevId()
{
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}
	ClusterDeviceInfo tClusterDeviceInfo = {0};
	int iResultSize = 0;
	int iRet = 0;
	tClusterDeviceInfo.iDevId = m_cboDevID.GetCurSel();
	tClusterDeviceInfo.iSize = sizeof(ClusterDeviceInfo);
	iRet = DEC_ClientGetClusterConfig(m_lLogonID, CLUSTER_DEVICE_INFO, &tClusterDeviceInfo, sizeof(ClusterDeviceInfo), &iResultSize);
	if(0 == iRet)
	{
		SetDlgItemInt(IDC_EDT_CTRLCARD, tClusterDeviceInfo.iCtrlCardNum);
		SetDlgItemInt(IDC_EDT_ALARMIN, tClusterDeviceInfo.iAlarmInNum);
		SetDlgItemInt(IDC_EDT_ALARMOUT, tClusterDeviceInfo.iAlarmOutNum);
		SetDlgItemInt(IDC_EDT_SLOTDNUM, tClusterDeviceInfo.iSlotdNum);
	}
}

BOOL CPageDeviceInfo::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}
	ClusterInfo tClusterInfo = {0};
	int iResultSize = 0;
	tClusterInfo.iSize = sizeof(ClusterInfo);
	DEC_ClientGetClusterConfig(m_lLogonID, CLUSTER_CLUSTERINFO, &tClusterInfo, sizeof(ClusterInfo), &iResultSize);
	for(int i = 0; i < tClusterInfo.iDevNum; i++)
	{
		CString cstext;
		cstext.Format("%d", i);
		m_cboDevID.AddString(cstext);
	}
	m_cboDevID.SetCurSel(0);

	OnCbnSelchangeCboDevId();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
